/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.tiles;

import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.EnergyTile;
import al132.alib.tiles.FluidTile;
import al132.alib.tiles.InventoryTile;
import al132.alib.utils.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ABaseTile
extends BlockEntity
implements Nameable {
    private int notifyTicks = 0;
    public IEnergyStorage energy;
    public LazyOptional<IEnergyStorage> energyHolder;

    public ABaseTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        if (this instanceof EnergyTile) {
            this.energy = ((EnergyTile)((Object)this)).initEnergy();
            this.energyHolder = LazyOptional.of(() -> this.energy);
        }
    }

    public boolean onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AtomicBoolean didInteract = new AtomicBoolean(false);
        if (this instanceof FluidTile) {
            ItemStack heldItem = player.m_21120_(hand);
            heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(x -> {
                didInteract.set(FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, null));
                this.m_6596_();
            });
        }
        return didInteract.get();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (this instanceof EnergyTile) {
            int max = ((EnergyTile)((Object)this)).getEnergy().getMaxEnergyStored();
            this.energy = ((EnergyTile)((Object)this)).initEnergy();
            if (this.energy instanceof CustomEnergyStorage) {
                ((CustomEnergyStorage)this.energy).receiveEnergyInternal(compound.m_128451_("energy"), false);
            } else {
                this.energy.receiveEnergy(compound.m_128451_("energy"), false);
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this instanceof EnergyTile) {
            compound.m_128405_("energy", this.energy.getEnergyStored());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && this instanceof EnergyTile) {
            return this.energyHolder.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof InventoryTile) {
            return ((InventoryTile)((Object)this)).getExternalInventory().cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this instanceof FluidTile) {
            return ((FluidTile)((Object)this)).getFluidHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public TextComponent getDisplayName() {
        String regName = this.m_58903_().getRegistryName().m_135815_().replaceAll("_", " ");
        return new TextComponent(Utils.capitalizeAllWords(regName));
    }

    public void updateGUIEvery(int ticks) {
        ++this.notifyTicks;
        if (this.notifyTicks >= ticks) {
            if (this.f_58857_ != null) {
                BlockState state = this.m_58900_();
                this.f_58857_.m_7260_(this.m_58899_(), state, state, 22);
            }
            this.notifyTicks = 0;
        }
    }

    public void updateGUI() {
        if (this.f_58857_ != null) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 22);
        }
    }
}

